const express = require("express");
const path = require("path");
const cors = require("cors");

const app = express();
const PORT = 3300;

app.use(cors());
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// API routes
const apiRoutes = require("./api");
app.use("/", apiRoutes);

// Serve static files from Angular
app.use(express.static(path.join(__dirname, "../polymers/")));

// ❗ Catch-all for Angular ONLY — skip /api requests
app.get("*", (req, res) => {
  if (req.path.startsWith("/api")) {
    return res.status(404).json({ error: "API route not found" });
  }
  res.sendFile(path.join(__dirname, "../polymers", "index.html"));
});

// Start the server
app.listen(PORT, () => {
  console.log(`Server running at http://localhost:${PORT}`);
});
